//Simulation of TDMA (Time Division Multiplexing and Demultiplexing) Technique) 
// OS-Windows 10
// Scilab 6.1.0
// Course Instructor Name: Dr. V. A. Sankar Ponnapalli
// Institute Name: ICFAI Foundation for Higher Education Hyderabad

clear; 
clc;
close;

disp("=== TDMA System Simulation ===");

N_r = input("Enter number of traffic bursts per frame (N_r) [1–100]: "); 
b_r = input("Enter number of bits per traffic burst (b_r) [100–1000]: ");
N_p = input("Enter number of preambles per frame (N_p) [1–10]: "); 
b_p = input("Enter bits per preamble (b_p) [10–100]: ");
N_g = input("Enter number of guard intervals per frame (N_g) [1–20]: ");
b_g = input("Enter bits per guard time interval (b_g) [1–50]: ");
T_f = input("Enter frame duration T_f in seconds [e.g., 0.01]: ");
R_b = input("Enter bit rate R_b in bits/sec [e.g., 1e6]: "); 

//Overhead bits per frame
b_OH = N_p*b_p + N_g*b_g;
disp("Total overhead bits per frame (b_OH): " + string(b_OH));

//Total bits per frame
b_T = T_f * R_b;
disp("Total bits per frame (b_T): " + string(b_T));

//Frame Efficiency
eta_f = (1 - (b_OH / b_T)) * 100;
disp("Frame Efficiency (η_f) in %: " + string(eta_f));

// Number of TDMA Channels
m = input("Enter max users per channel (m) [1–100]: ");
B_tot = input("Enter total system bandwidth B_tot in Hz [e.g., 200e3]: ");
B_guard = input("Enter guard band on one side (B_guard) in Hz [e.g., 10e3]: ");
B_c = input("Enter bandwidth per channel B_c in Hz [e.g., 25e3]: "); 

N_channels = m * (B_tot - 2*B_guard) / B_c;
disp("Number of TDMA channels (N): " + string(N_channels));

x = [b_OH, b_T - b_OH];
bar(x);
xtitle("TDMA Frame Composition", "Bit Category", "Bits");
a = gca(); // get current axes
a.x_ticks = tlist(["ticks", "locations", "labels"], [1; 2], ["Overhead Bits"; "Information Bits"]);

// Description of the Figure
// User Inputs:

//Enter number of traffic bursts per frame (N_r) [1–100]: 50
//Enter number of bits per traffic burst (b_r) [100–1000]: 150
//Enter number of preambles per frame (N_p) [1–10]: 5
//Enter bits per preamble (b_p) [10–100]: 50
//Enter number of guard intervals per frame (N_g) [1–20]: 10
//Enter bits per guard time interval (b_g) [1–50]: 5
//Enter frame duration T_f in seconds [e.g., 0.01]: 0.01
//Enter bit rate R_b in bits/sec [e.g., 1e6]: 1e6
//Enter max users per channel (m) [1–100]: 50
//Enter total system bandwidth B_tot in Hz [e.g., 200e3]: 200e3
//Enter guard band on one side (B_guard) in Hz [e.g., 10e3]: 10e3
//Enter bandwidth per channel B_c in Hz [e.g., 25e3]: 25e3
//The left bar labeled “Overhead Bits” represents preambles and guard intervals that support synchronization and prevent interference.
//The right bar labeled “Information Bits” represents actual user data.
